#version 430 core

layout (location = 0) in vec3 fragNormal;
layout (location = 1) in vec2  fragTexCoords;
layout (location = 2) in vec4  fragViewPos;
layout (location = 3) in float  fragD;

layout (location = 0) out vec4 gAlbedoSpec;
layout (location = 1) out vec4 gViewPosition; //last one is also depth
layout (location = 2) out vec3 gNormal;
layout (location = 3) out vec4 gShadowVisibility;
layout (location = 4) out vec2 gInstanceID;
layout (location = 5) out vec4 gPhysical;

uniform float magnitude;

uniform sampler2D noiseTex;
uniform sampler2D rampTex;

uniform float lifeRatio;


float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}


void main()
{       

	float progress = lifeRatio * fragD;

	float endOfLifeNoise = texture(noiseTex, fragTexCoords).r;

	vec2 rampCoords = vec2(progress, 0.5);

	float lifeRatioBloomMulti = 1.0;

	if(lifeRatio > 0.8){
		
		float lifeRatioContribution = (lifeRatio - 0.8) * 5.0;

		float endOfLifeNoiseContribution = endOfLifeNoise / 5.0f;

		if(lifeRatioContribution + endOfLifeNoiseContribution >= 1.0){
			discard;
		}

		lifeRatioBloomMulti = 1.0 - (lifeRatioContribution + endOfLifeNoiseContribution);

		rampCoords = vec2(progress + (lifeRatio - 0.8), 0.5);
	
	}

	gViewPosition.w = linearize_depth(gl_FragCoord.z, 1.0, 6000);

	gAlbedoSpec.rgb = texture(rampTex, rampCoords).rgb;

	gAlbedoSpec.a = 1.0;

	float bloomAmount = ((1.0 - lifeRatio) - 0.3) / 0.7;

	bloomAmount = clamp(bloomAmount, 0.0, 1.0);

	gPhysical = vec4(1.0, 1.0, bloomAmount, 0.0);

	gNormal = fragNormal;
	gInstanceID = vec2(0.0);
	gViewPosition.xyz = fragViewPos.xyz;
	gShadowVisibility = vec4(0.0);
}